/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;

public final class PgbIndexedVideoOutput
extends PgbVideoOutput {
    Graphics graph;
    MemoryImageSource mISrc;
    Image mImg;
    byte[] packedScreenPalette = new byte[192];
    MemoryImageSource borderMISrc;
    Image borderMImg;
    ColorModel borderColorModel;
    byte[] packedBorderPalette;

    public void setGraphics() {
        this.graph = this.getGraphics();
    }

    public PgbIndexedVideoOutput(PgbVideo pgbVideo) {
        super(pgbVideo);
        this.mISrc = new MemoryImageSource(160, 144, (ColorModel)new IndexColorModel(6, 64, this.packedScreenPalette, 0, false), pgbVideo.getScreenMemory(), 0, 160);
        this.mISrc.setAnimated(true);
        this.mImg = this.createImage(this.mISrc);
        this.packedBorderPalette = new byte[768];
        this.borderColorModel = new IndexColorModel(8, 256, this.packedBorderPalette, 0, false);
    }

    public void reset() {
    }

    public void hblank(int n) {
    }

    public void vblank() {
        this.mISrc.newPixels(this.video.getScreenMemory(), this.getScreenColorModel(), 0, 160);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void makeScreenshot() {
        Date date = new Date();
        long l = date.getTime();
        int n = this.mImg.getWidth(this);
        int n2 = this.mImg.getHeight(this);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.mImg, 0, 0, null);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File("AEPgb-" + l + ".png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void update(Graphics graphics) {
        if (PgbSettings.sgbborder) {
            graphics.drawImage(this.mImg, 48 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 160 * PgbSettings.lcdsize, 144 * PgbSettings.lcdsize, this);
            graphics.drawImage(this.borderMImg, 0 * PgbSettings.lcdsize, 0 * PgbSettings.lcdsize, 256 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 0, 0, 256, 40, this);
            graphics.drawImage(this.borderMImg, 0 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 48 * PgbSettings.lcdsize, 184 * PgbSettings.lcdsize, 0, 40, 48, 184, this);
            graphics.drawImage(this.borderMImg, 208 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 256 * PgbSettings.lcdsize, 184 * PgbSettings.lcdsize, 208, 40, 256, 184, this);
            graphics.drawImage(this.borderMImg, 0 * PgbSettings.lcdsize, 184 * PgbSettings.lcdsize, 256 * PgbSettings.lcdsize, 224 * PgbSettings.lcdsize, 0, 184, 256, 224, this);
        } else {
            graphics.drawImage(this.mImg, 0, 0, 160 * PgbSettings.lcdsize, 144 * PgbSettings.lcdsize, this);
        }
    }

    public ColorModel getScreenColorModel() {
        if (PgbSettings.system == 11) {
            for (byte by = 0; by < 64; by = (byte)(by + 1)) {
                this.packedScreenPalette[by * 3 + 0] = this.video.getScreenRed(by);
                this.packedScreenPalette[by * 3 + 1] = this.video.getScreenGreen(by);
                this.packedScreenPalette[by * 3 + 2] = this.video.getScreenBlue(by);
            }
            return new IndexColorModel(6, 64, this.packedScreenPalette, 0, false);
        }
        for (byte by = 0; by < 12; by = (byte)(by + 1)) {
            this.packedScreenPalette[by * 3 + 0] = this.video.getScreenRed(by);
            this.packedScreenPalette[by * 3 + 1] = this.video.getScreenGreen(by);
            this.packedScreenPalette[by * 3 + 2] = this.video.getScreenBlue(by);
        }
        return new IndexColorModel(4, 12, this.packedScreenPalette, 0, false);
    }
}

